/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui.localapplication;

import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import rappsilber.ms.ToleranceUnit;
import rappsilber.ms.dataAccess.filter.spectrafilter.MassFilteredSpectrumAccess;
import rappsilber.ms.dataAccess.filter.spectrafilter.RandomSpectraSubset;
import rappsilber.ms.dataAccess.filter.spectrafilter.ScanFilteredSpectrumAccess;
import rappsilber.ms.dataAccess.SpectraAccess;
import rappsilber.ms.dataAccess.msm.AbstractMSMAccess;
import rappsilber.ms.dataAccess.output.MSMWriter;
import rappsilber.gui.components.AutoAddTableModelListener;
import rappsilber.gui.components.GenericTextPopUpMenu;
import rappsilber.gui.logging.JMessageBoxHandle;
import rappsilber.gui.logging.JTextAreaHandle;
import rappsilber.ms.dataAccess.AbstractStackedSpectraAccess;
import rappsilber.ms.dataAccess.BufferedSpectraAccess;
import rappsilber.ms.dataAccess.filter.spectrafilter.CompareScanMemory;
import rappsilber.ms.dataAccess.filter.spectrafilter.Denoise;
import rappsilber.ms.dataAccess.filter.spectrafilter.PeakFilteredSpectrumAccess;
import rappsilber.ms.dataAccess.filter.spectrafilter.ScanMemory;
import rappsilber.ms.dataAccess.msm.MSMIterator;
import rappsilber.ms.dataAccess.msm.MSMListIterator;
import rappsilber.ms.spectra.Spectra;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class ScanFilter extends javax.swing.JFrame {

    /** Creates new form ConsistentPeaks */
    public ScanFilter() {
        initComponents();
        JMessageBoxHandle errorLog = new JMessageBoxHandle(false);
        JTextAreaHandle errorLog2 = new JTextAreaHandle(txtLog);
        Filter allLogEvents = new Filter() {
            public boolean isLoggable(LogRecord record) {
                return true;
            }
        };
        errorLog.setFilter(allLogEvents);

        errorLog.setLevel(Level.WARNING);

        Logger.getLogger("rappsilber").addHandler(errorLog);

        errorLog2.setFilter(allLogEvents);

        errorLog2.setLevel(Level.INFO);

        Logger.getLogger("rappsilber").addHandler(errorLog2);

        Logger.getLogger("rappsilber").setLevel(Level.ALL);
        Logger.getLogger("rappsilber").addHandler(errorLog);


        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Logger Connected");


        fbMassFilterFile.setDescription("CSV-file");
        fbMassFilterFile.setExtensions(new String[]{".csv"});
        fbMSMFile.setDescription("MSM-File");
        fbMSMFile.setExtensions(new String[]{".msm",".mgf",".apl",".msmlist"});
        fbMSMOut.setDescription("MSM-File");
        fbMSMOut.setExtensions(new String[]{".msm",".mgf"});
        fbMSMOut.setSave();

        flMSMFiles.setExtensions(new String[]{".msm",".apl",".mgf",".msmlist"});
        flMSMFiles.setDescription("MSM-files");        
        

        tblMassFilter.getModel().addTableModelListener(new AutoAddTableModelListener());
        tblHasPeakFilter.getModel().addTableModelListener(new AutoAddTableModelListener());

        GenericTextPopUpMenu copyPaste = new GenericTextPopUpMenu();
        copyPaste.installContextMenu(this);
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        grpWhiteBlackList = new javax.swing.ButtonGroup();
        tabs = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        fbMSMFile = new rappsilber.gui.components.FileBrowser();
        btnRun = new javax.swing.JButton();
        fbMSMOut = new rappsilber.gui.components.FileBrowser();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtLog = new javax.swing.JTextArea();
        chkRandom = new javax.swing.JCheckBox();
        spRandom = new javax.swing.JSpinner();
        spMinCharge = new javax.swing.JSpinner();
        lblMinCharge = new javax.swing.JLabel();
        cbChargeOnly = new javax.swing.JCheckBox();
        spProgress = new javax.swing.JScrollPane();
        txtProgress = new javax.swing.JTextField();
        ckDeIsotop = new javax.swing.JCheckBox();
        ckDeCharge = new javax.swing.JCheckBox();
        ckDeLoss = new javax.swing.JCheckBox();
        spToleranceValueDeICL = new javax.swing.JSpinner();
        cbToleranceUnitDeICL = new javax.swing.JComboBox();
        flMSMFiles = new rappsilber.gui.components.FileList();
        scanFilterComponent = new rappsilber.gui.components.filter.ScanFilterComponentCsvCopyPaste();
        pnlHasPeakFilter = new javax.swing.JPanel();
        scpHasPeakFilter = new javax.swing.JScrollPane();
        tblHasPeakFilter = new javax.swing.JTable();
        fbHasPeakFilter = new rappsilber.gui.components.FileBrowser();
        btnReadHasPeakFilter = new javax.swing.JButton();
        cbToleranceUnitPeakFilter = new javax.swing.JComboBox();
        spToleranceValuePeakFilter = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        chkAllPeaks = new javax.swing.JCheckBox();
        spMinPeaks = new javax.swing.JSpinner();
        lblMinPeaks1 = new javax.swing.JLabel();
        lblMinPeaks2 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        tblMassFilter = new javax.swing.JTable();
        fbMassFilterFile = new rappsilber.gui.components.FileBrowser();
        spToleranceValue = new javax.swing.JSpinner();
        cbToleranceUnit = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        btnReadMassFilter = new javax.swing.JButton();
        denoiseFilterGui1 = new rappsilber.gui.components.filter.DenoiseFilterGui();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("XLink MSM Filter");

        jLabel2.setText("Read from");

        btnRun.setText("run");
        btnRun.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRunActionPerformed(evt);
            }
        });

        jLabel4.setText("Write to");

        txtLog.setColumns(20);
        txtLog.setRows(5);
        jScrollPane1.setViewportView(txtLog);

        chkRandom.setText("Random Subset");
        chkRandom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkRandomActionPerformed(evt);
            }
        });

        spRandom.setModel(new javax.swing.SpinnerNumberModel(10, 2, null, 1));
        spRandom.setEnabled(false);

        spMinCharge.setModel(new javax.swing.SpinnerNumberModel(0, 0, null, 1));

        lblMinCharge.setText("Minimal charge");

        cbChargeOnly.setText("Only This");
        cbChargeOnly.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbChargeOnlyActionPerformed(evt);
            }
        });

        txtProgress.setEditable(false);
        spProgress.setViewportView(txtProgress);

        ckDeIsotop.setText("De-Isotop");
        ckDeIsotop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ckDeIsotopActionPerformed(evt);
            }
        });

        ckDeCharge.setText("De-Charge");

        ckDeLoss.setText("De-Loss");

        spToleranceValueDeICL.setModel(new javax.swing.SpinnerNumberModel(20.0d, 0.0d, null, 1.0d));

        cbToleranceUnitDeICL.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ppm", "da" }));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(ckDeIsotop)
                        .addGap(18, 18, 18)
                        .addComponent(ckDeCharge)
                        .addGap(18, 18, 18)
                        .addComponent(ckDeLoss)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(spToleranceValueDeICL, javax.swing.GroupLayout.PREFERRED_SIZE, 49, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbToleranceUnitDeICL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel4))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(fbMSMOut, javax.swing.GroupLayout.DEFAULT_SIZE, 481, Short.MAX_VALUE)
                            .addComponent(fbMSMFile, javax.swing.GroupLayout.DEFAULT_SIZE, 481, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addComponent(chkRandom)
                        .addGap(18, 18, 18)
                        .addComponent(spRandom, javax.swing.GroupLayout.PREFERRED_SIZE, 49, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(lblMinCharge)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(spMinCharge, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbChargeOnly)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE)
                        .addComponent(btnRun))
                    .addComponent(spProgress, javax.swing.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fbMSMFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fbMSMOut, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnRun)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(chkRandom)
                        .addComponent(spRandom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(spMinCharge, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(lblMinCharge)
                        .addComponent(cbChargeOnly)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ckDeIsotop)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(ckDeCharge)
                        .addComponent(ckDeLoss)
                        .addComponent(spToleranceValueDeICL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(cbToleranceUnitDeICL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(spProgress, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 84, Short.MAX_VALUE)
                .addContainerGap())
        );

        tabs.addTab("MSM", jPanel1);
        tabs.addTab("MSM-Files", flMSMFiles);
        tabs.addTab("ScanFilter", scanFilterComponent);

        tblHasPeakFilter.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null}
            },
            new String [] {
                "m/z", "Min Relative intensity", "Min Absolute intensity"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Double.class, java.lang.Double.class, java.lang.Double.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        tblHasPeakFilter.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                tblHasPeakFiltertblFilterKeyReleased(evt);
            }
        });
        scpHasPeakFilter.setViewportView(tblHasPeakFilter);

        btnReadHasPeakFilter.setText("Read");
        btnReadHasPeakFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnReadHasPeakFilterActionPerformed(evt);
            }
        });

        cbToleranceUnitPeakFilter.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ppm", "da" }));

        spToleranceValuePeakFilter.setModel(new javax.swing.SpinnerNumberModel(20.0d, 0.0d, null, 1.0d));

        jLabel5.setText("Tolerance");

        chkAllPeaks.setText("require all peaks");
        chkAllPeaks.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkAllPeaksActionPerformed(evt);
            }
        });

        spMinPeaks.setModel(new javax.swing.SpinnerNumberModel(1, 1, null, 1));

        lblMinPeaks1.setText("at least");

        lblMinPeaks2.setText("peaks");

        javax.swing.GroupLayout pnlHasPeakFilterLayout = new javax.swing.GroupLayout(pnlHasPeakFilter);
        pnlHasPeakFilter.setLayout(pnlHasPeakFilterLayout);
        pnlHasPeakFilterLayout.setHorizontalGroup(
            pnlHasPeakFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlHasPeakFilterLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlHasPeakFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(scpHasPeakFilter, javax.swing.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlHasPeakFilterLayout.createSequentialGroup()
                        .addComponent(fbHasPeakFilter, javax.swing.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnReadHasPeakFilter))
                    .addGroup(pnlHasPeakFilterLayout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(spToleranceValuePeakFilter, javax.swing.GroupLayout.PREFERRED_SIZE, 49, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbToleranceUnitPeakFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(chkAllPeaks)
                        .addGap(18, 18, 18)
                        .addComponent(lblMinPeaks1)
                        .addGap(5, 5, 5)
                        .addComponent(spMinPeaks, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lblMinPeaks2)))
                .addContainerGap())
        );
        pnlHasPeakFilterLayout.setVerticalGroup(
            pnlHasPeakFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlHasPeakFilterLayout.createSequentialGroup()
                .addGroup(pnlHasPeakFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(spToleranceValuePeakFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cbToleranceUnitPeakFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chkAllPeaks)
                    .addComponent(spMinPeaks, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblMinPeaks1)
                    .addComponent(lblMinPeaks2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(scpHasPeakFilter, javax.swing.GroupLayout.DEFAULT_SIZE, 214, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(pnlHasPeakFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnReadHasPeakFilter)
                    .addComponent(fbHasPeakFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        tabs.addTab("HasPeakFilter", pnlHasPeakFilter);

        tblMassFilter.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null}
            },
            new String [] {
                "Mass"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Double.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        tblMassFilter.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                tblFilterKeyReleased(evt);
            }
        });
        jScrollPane3.setViewportView(tblMassFilter);

        spToleranceValue.setModel(new javax.swing.SpinnerNumberModel(6.0d, 0.0d, null, 1.0d));

        cbToleranceUnit.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ppm", "da" }));

        jLabel3.setText("Tolerance");

        btnReadMassFilter.setText("Read");
        btnReadMassFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnReadMassFilterActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(fbMassFilterFile, javax.swing.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnReadMassFilter))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(spToleranceValue, javax.swing.GroupLayout.PREFERRED_SIZE, 49, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbToleranceUnit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(spToleranceValue, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cbToleranceUnit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 214, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(fbMassFilterFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnReadMassFilter))
                .addContainerGap())
        );

        tabs.addTab("PrecoursorMassFilter", jPanel3);

        denoiseFilterGui1.setEnabled(false);
        tabs.addTab("Denoise", denoiseFilterGui1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(tabs)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(tabs, javax.swing.GroupLayout.DEFAULT_SIZE, 320, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnRunActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRunActionPerformed
        btnRun.setEnabled(false);
        Runnable runnable = new Runnable() {

            public void run() {
                int count =0;
                int countRead = 0;
                try {
                    JLabel progress = new JLabel();
                    spProgress.add(progress);
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.INFO, "--- Start ---");
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.INFO, "--- get filter ---");
                    ScanFilteredSpectrumAccess fsa = scanFilterComponent.getScanFilter();
                    MassFilteredSpectrumAccess mfsa = getMassFilter();
                    PeakFilteredSpectrumAccess pfsa = getPeakFilter();
                    int mincharge = (Integer)spMinCharge.getModel().getValue();
                    

                    ToleranceUnit t = new ToleranceUnit((Double) spToleranceValue.getModel().getValue(), cbToleranceUnit.getModel().getSelectedItem().toString());
                    ToleranceUnit diclT = new ToleranceUnit((Double) spToleranceValueDeICL.getModel().getValue(), cbToleranceUnitDeICL.getModel().getSelectedItem().toString());
                    MSMListIterator iter = new MSMListIterator(diclT, mincharge, null);
//                    SpectraAccess msmr = AbstractMSMAccess.getMSMIterator(fbMSMFile.getText(), t, mincharge, null);
                    if (fbMSMFile.getText() != null && !fbMSMFile.getText().isEmpty())
                        iter.addFile(fbMSMFile.getFile().getAbsolutePath(), "", t);
                    File[] list = flMSMFiles.getFiles();
                    if (list.length>0) {
                        for (File f: list) 
                            iter.addFile(f.getAbsolutePath(), "", t);
                    }
                    
                    iter.init();
                    
                    SpectraAccess sa = iter;
                    
                    if (fsa != null) {
                        BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                        fsa.setReader(bsa);
                        sa = fsa;
                    }
                    if (mfsa != null) {
                        BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                        mfsa.setReader(bsa);
                        sa = mfsa;
                    }

                    if (pfsa != null) {
                        BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                        pfsa.setReader(bsa);
                        sa = pfsa;
                    }

                    if (chkRandom.isSelected()) {
                        BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                        RandomSpectraSubset rss = new RandomSpectraSubset(bsa, (Integer)spRandom.getModel().getValue());
                        sa = rss;
                    }

                    if (denoiseFilterGui1.isEnabled()) {

                        BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                        AbstractStackedSpectraAccess d = denoiseFilterGui1.getFilter();
                        d.setReader(bsa);
                        sa = d;
                    }
                    
                    MSMWriter msmw = new MSMWriter(fbMSMOut.getFile(), "", "", "");
                    msmw.writeHeader();
                    btnRun.setEnabled(true);

                    BufferedSpectraAccess bsa = new BufferedSpectraAccess(sa, 100);
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.INFO, "--- start running ---");
                    if (cbChargeOnly.isSelected()) {
                        while (bsa.hasNext()) {
                            Spectra s = bsa.next();

                            if (s.getPrecoursorChargeAlternatives().length == 1 && s.getPrecurserCharge() == mincharge) {
                                if (count ++ %100 == 0) {
                                    updateProgress(this , iter.countReadSpectra() + " spectra read " + msmw.getResultCount() + " spectra writen");
                                }
                                Spectra os = SpectraPostProcessing(s, diclT);
                                msmw.writeSpectra(os);
  //                              progress.setText("Spectra writen: " + msmw.getResultCount());
                            }
                        }
                    } else {
                        while (bsa.hasNext()) {
                            if (count ++ %100 == 0) {
                                updateProgress(this , iter.countReadSpectra() + " spectra read " + msmw.getResultCount() + " spectra writen");
                            }
                            Spectra os = SpectraPostProcessing(bsa.next(), diclT);
                            msmw.writeSpectra(os);
//                            progress.setText("Spectra writen: " + msmw.getResultCount());
                        }
                    }
                    bsa.close();
                    countRead = iter.countReadSpectra();
                    msmw.close();
                    iter.close();
                    updateProgress(this , iter.countReadSpectra() + " spectra read " + msmw.getResultCount() + " spectra writen");
                    spProgress.remove(progress);
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.INFO, iter.countReadSpectra() + " spectra read " + msmw.getResultCount() + " spectra writen");
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.INFO, "--- Finished ---");
                } catch (FileNotFoundException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "File not found", ex);
                    JOptionPane.showMessageDialog(rootPane, ex.getLocalizedMessage(), "file not found", JOptionPane.ERROR_MESSAGE);
                } catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error wile reading file " , ex);
                    JOptionPane.showMessageDialog(rootPane, ex.getLocalizedMessage(), "Error wile reading file ", JOptionPane.ERROR_MESSAGE);
                } catch (ParseException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(rootPane, ex.getLocalizedMessage(), "Error wile reading file ", JOptionPane.ERROR_MESSAGE);
                }        
                JOptionPane.showMessageDialog(rootPane, "Finished", "Finished",JOptionPane.INFORMATION_MESSAGE);
                updateProgress(this , "finished " + count + " spectra writen");
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException ex) {
                    Logger.getLogger(ScanFilter.class.getName()).log(Level.SEVERE, null, ex);
                }
                updateProgress(this , null);
                btnRun.setEnabled(true);
                
            }

            protected Spectra SpectraPostProcessing(Spectra s, ToleranceUnit diclT) {
                Spectra os = s;
                s.setTolearance(diclT);
                if (ckDeLoss.isSelected() || ckDeIsotop.isSelected() || ckDeCharge.isSelected()) {
                    os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                }
                // de-Loss
                //H20;18.01056027
                //## Amonia
                //NH2;:17.02654493
                if (ckDeLoss.isSelected()) {
                    os = os.cloneComplete();
                    os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                    os.setTolearance(diclT);
                    os = os.deLoss(18.01056027);
                    os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                    os = os.deLoss(17.02654493);
                }
                if (ckDeIsotop.isSelected()) {
                    if (ckDeCharge.isSelected()) {
                        os = os.clone();
                        os.setTolearance(diclT);
                        os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                        os = os.deChargeDeisotop();
                    } else {
                        os = os.clone();
                        os.setTolearance(diclT);
                        os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                        os = os.deIsotop();
                    }
                } else if (ckDeCharge.isSelected()) {
                    os = os.clone();
                    os.setTolearance(diclT);
                    os.DEFAULT_ISOTOP_DETECTION.anotate(os);
                    os = os.deCharge();
                }
                return os;
            }
        };
        Thread t = new Thread(runnable);
        t.start();


    }//GEN-LAST:event_btnRunActionPerformed

    private void btnReadMassFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnReadMassFilterActionPerformed
        DefaultTableModel tm = ((DefaultTableModel)tblMassFilter.getModel());

        String file  = fbMassFilterFile.getText();
        if (file != null || file.length() >0) {
            File in = new File(file);
            if (!in.exists()) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            BufferedReader br;
            try {
                br = new BufferedReader(new FileReader(in));
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String line;
            try {
                int editRow = tm.getRowCount() - 1;
                while ((line = br.readLine()) != null) {
                    if (line.matches("^\\s*[0-9]*(\\.[0-9]*)?\\s*(,.*)?$")) {
                        String[] data = line.split(",",2);
                        tm.setValueAt(new Double(data[0]), editRow++, 0);
                    }
                }
            } catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error while reading file " + file + " !", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
        }

    }//GEN-LAST:event_btnReadMassFilterActionPerformed

    private void tblFilterKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tblFilterKeyReleased
        if(evt.getKeyCode() == KeyEvent.VK_DELETE) {
            JTable tbl = (JTable) evt.getSource();
            if (tbl.getSelectedRowCount() > 0) {
                DefaultTableModel tm = (DefaultTableModel) tbl.getModel();
                int LastRow = tm.getRowCount();
                int[] rows = tbl.getSelectedRows();
                for (int r = rows.length;r-->0;)
                    if (r<LastRow)
                        tm.removeRow(r);
                
            }
        }
    }//GEN-LAST:event_tblFilterKeyReleased

    private void chkRandomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkRandomActionPerformed
        spRandom.setEnabled(chkRandom.isSelected());
    }//GEN-LAST:event_chkRandomActionPerformed

    private void tblHasPeakFiltertblFilterKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tblHasPeakFiltertblFilterKeyReleased
    }//GEN-LAST:event_tblHasPeakFiltertblFilterKeyReleased

    private void btnReadHasPeakFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnReadHasPeakFilterActionPerformed

        DefaultTableModel tm = ((DefaultTableModel)tblHasPeakFilter.getModel());

        String file  = fbHasPeakFilter.getText();
        if (file != null || file.length() >0) {
            File in = new File(file);
            if (!in.exists()) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            BufferedReader br;
            try {
                br = new BufferedReader(new FileReader(in));
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String line;
            try {
                int editRow = tm.getRowCount() - 1;
                while ((line = br.readLine()) != null) {
                    if (line.matches("^\\s*[0-9]*(\\.[0-9]*)?\\s*(,s*[0-9]*(\\.[0-9]*)?\\s*(,s*[0-9]*(\\.[0-9]*)?\\s*)?)?$")) {
                        String[] data = line.split(",",3);
                        tm.setValueAt(Double.parseDouble(data[0]), editRow, 0);
                        if (data.length >1) {
                            tm.setValueAt(Double.parseDouble(data[1]), editRow, 1);
                            if (data.length > 2) {
                                tm.setValueAt(Double.parseDouble(data[2]), editRow, 2);
                            }
                        }
                        editRow++;
                    }
                }
            } catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error while reading file " + file + " !", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
        }


    }//GEN-LAST:event_btnReadHasPeakFilterActionPerformed

    private void cbChargeOnlyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbChargeOnlyActionPerformed
        if (cbChargeOnly.isSelected()) {
            lblMinCharge.setText("Charge");
        } else {
            lblMinCharge.setText("Minimal charge");
        }
    }//GEN-LAST:event_cbChargeOnlyActionPerformed

    private void chkAllPeaksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkAllPeaksActionPerformed
        boolean e = !chkAllPeaks.isSelected();
        lblMinPeaks1.setEnabled(e);
        lblMinPeaks2.setEnabled(e);
        spMinPeaks.setEnabled(e);
    }//GEN-LAST:event_chkAllPeaksActionPerformed

    private void ckDeIsotopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ckDeIsotopActionPerformed
    }//GEN-LAST:event_ckDeIsotopActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ScanFilter().setVisible(true);
            }
        });
    }


//    protected ScanFilteredSpectrumAccess getScanFilter() {
//        ScanFilteredSpectrumAccess fsa = new ScanFilteredSpectrumAccess(rdWhiteList.isSelected());
//        DefaultTableModel tm = (DefaultTableModel) tblScanFilter.getModel();
//        int count =0;
//        for (int i = 0; i< tm.getRowCount() - 1; i++) {
//            if (tm.getValueAt(i, 0) != null&& tm.getValueAt(i, 1) != null) {
//                fsa.SelectScan(tm.getValueAt(i, 0).toString(), new Integer(tm.getValueAt(i, 1).toString()));
//                count ++;
//            }
//        }
//        if (count>0)
//            return fsa;
//        else
//            return null;
//    }

    protected PeakFilteredSpectrumAccess getPeakFilter() {
        PeakFilteredSpectrumAccess fsa = new PeakFilteredSpectrumAccess(new ToleranceUnit((Double)spToleranceValue.getModel().getValue(), cbToleranceUnit.getModel().getSelectedItem().toString()));
        DefaultTableModel tm = (DefaultTableModel) tblHasPeakFilter.getModel();

        if (chkAllPeaks.isSelected()) {
            fsa.setFindAll();
        } else {
            fsa.setMinimumFoundPeaks((Integer)spMinPeaks.getModel().getValue());
        }

        int count =0;
        for (int i = 0; i< tm.getRowCount(); i++) {
            if (tm.getValueAt(i, 0) != null) {
                double mz = (Double)tm.getValueAt(i, 0);
                Double minRel = (Double)tm.getValueAt(i, 1);
                Double minAbs = (Double)tm.getValueAt(i, 2);

                if (minRel == null)
                    minRel = new Double(0);

                if (minAbs == null)
                    minAbs = new Double(0);

                fsa.addPeak(mz, minAbs, minRel);
                count ++;
            }
        }
        if (count>0)
            return fsa;
        else
            return null;
    }

    protected MassFilteredSpectrumAccess getMassFilter() {
        MassFilteredSpectrumAccess fsa = new MassFilteredSpectrumAccess(new ToleranceUnit((Double)spToleranceValue.getModel().getValue(), cbToleranceUnit.getModel().getSelectedItem().toString()));
        DefaultTableModel tm = (DefaultTableModel) tblMassFilter.getModel();
        int count =0;
        for (int i = 0; i< tm.getRowCount(); i++) {
            if (tm.getValueAt(i, 0) != null) {
                fsa.SelectMass((Double)tm.getValueAt(i, 0));
                count ++;
            }
        }
        if (count>0)
            return fsa;
        else
            return null;
    }
    
    HashMap<Object,String> m_statusMessages = new HashMap<Object, String>();
    public void updateProgress(Object ref, String message) {
        if (message == null) {
            m_statusMessages.remove(ref);
        } else {
            m_statusMessages.put(ref, message);
        }
        StringBuffer sb = new StringBuffer();
        for (Object o : m_statusMessages.keySet()) {
            sb.append(m_statusMessages.get(o));
            sb.append(" |");
        }
        if (sb.length() ==0) 
            txtProgress.setText("");
        else
            txtProgress.setText(sb.substring(0,sb.length()-1));
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnReadHasPeakFilter;
    private javax.swing.JButton btnReadMassFilter;
    private javax.swing.JButton btnRun;
    private javax.swing.JCheckBox cbChargeOnly;
    private javax.swing.JComboBox cbToleranceUnit;
    private javax.swing.JComboBox cbToleranceUnitDeICL;
    private javax.swing.JComboBox cbToleranceUnitPeakFilter;
    private javax.swing.JCheckBox chkAllPeaks;
    private javax.swing.JCheckBox chkRandom;
    private javax.swing.JCheckBox ckDeCharge;
    private javax.swing.JCheckBox ckDeIsotop;
    private javax.swing.JCheckBox ckDeLoss;
    private rappsilber.gui.components.filter.DenoiseFilterGui denoiseFilterGui1;
    private rappsilber.gui.components.FileBrowser fbHasPeakFilter;
    private rappsilber.gui.components.FileBrowser fbMSMFile;
    private rappsilber.gui.components.FileBrowser fbMSMOut;
    private rappsilber.gui.components.FileBrowser fbMassFilterFile;
    private rappsilber.gui.components.FileList flMSMFiles;
    private javax.swing.ButtonGroup grpWhiteBlackList;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel lblMinCharge;
    private javax.swing.JLabel lblMinPeaks1;
    private javax.swing.JLabel lblMinPeaks2;
    private javax.swing.JPanel pnlHasPeakFilter;
    private rappsilber.gui.components.filter.ScanFilterComponentCsvCopyPaste scanFilterComponent;
    private javax.swing.JScrollPane scpHasPeakFilter;
    private javax.swing.JSpinner spMinCharge;
    private javax.swing.JSpinner spMinPeaks;
    private javax.swing.JScrollPane spProgress;
    private javax.swing.JSpinner spRandom;
    private javax.swing.JSpinner spToleranceValue;
    private javax.swing.JSpinner spToleranceValueDeICL;
    private javax.swing.JSpinner spToleranceValuePeakFilter;
    private javax.swing.JTabbedPane tabs;
    private javax.swing.JTable tblHasPeakFilter;
    private javax.swing.JTable tblMassFilter;
    private javax.swing.JTextArea txtLog;
    private javax.swing.JTextField txtProgress;
    // End of variables declaration//GEN-END:variables

}
