/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui.components.filter;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import rappsilber.data.csv.CSVRandomAccess;
import rappsilber.ms.dataAccess.filter.spectrafilter.ScanFilteredSpectrumAccess;
import rappsilber.utils.ColumnAlternatives;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class ScanFilterComponentCsvCopyPaste extends javax.swing.JPanel {

    /**
     * Creates new form ScanFilterComponent
     */
    public ScanFilterComponentCsvCopyPaste() {
        initComponents();
//        fbScanFilterFile.setDescription("CSV-file/PeakList");
//        fbScanFilterFile.setExtensions(new String[]{".csv","*.msm","*.mgf","*.apl","*.msmlist","*.zip"});
//        // replace the deault (nicly gui-generated) table model with a new one
//        tblScanFilter.setColumnSelectionAllowed(false);
//        tblScanFilter.setRowSelectionAllowed(false);
//        tblScanFilter.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//
//        tblScanFilter.getModel().addTableModelListener(new AutoAddTableModelListener());        
        
        csvScans.setAutoLoadFile(true);
        
        csvScans.addHeaderChangedListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                setHeaderComboBoxes();
            }
        });
        
        csvScans.setEditable(true);
        
                
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel2 = new javax.swing.JPanel();
        btnSpectraFilterClear = new javax.swing.JButton();
        rdWhiteList = new javax.swing.JRadioButton();
        rdBlackList = new javax.swing.JRadioButton();
        csvScans = new rappsilber.gui.components.CSVPanel();
        jPanel6 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        cbRun = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        cbScan = new javax.swing.JComboBox();

        btnSpectraFilterClear.setText("Clear");
        btnSpectraFilterClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSpectraFilterClearActionPerformed(evt);
            }
        });

        buttonGroup1.add(rdWhiteList);
        rdWhiteList.setSelected(true);
        rdWhiteList.setText("Include Selected");

        buttonGroup1.add(rdBlackList);
        rdBlackList.setText("Exclude Selected");

        csvScans.setHasHeader(true);
        csvScans.setShowSavePanel(false);

        jLabel1.setText("Run Column");

        cbRun.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "--Select--" }));

        jLabel2.setText("Scan Column");

        cbScan.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "--Select--" }));

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbScan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbRun, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(cbRun, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(cbScan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(csvScans, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addComponent(rdWhiteList)
                        .addGap(18, 18, 18)
                        .addComponent(rdBlackList)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                        .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 183, Short.MAX_VALUE)
                        .addComponent(btnSpectraFilterClear)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(rdWhiteList)
                    .addComponent(rdBlackList))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(csvScans, javax.swing.GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnSpectraFilterClear, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 696, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(0, 0, 0)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGap(0, 0, 0)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 355, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addGap(0, 0, 0)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGap(0, 0, 0)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnSpectraFilterClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSpectraFilterClearActionPerformed
        csvScans.getCSV().clear();
        csvScans.csvChanged();
//        DefaultTableModel tm = (DefaultTableModel) tblScanFilter.getModel();
//        for (int r = tm.getRowCount() - 2; r>=0;r--)
//        tm.removeRow(r);
    }//GEN-LAST:event_btnSpectraFilterClearActionPerformed

    public ScanFilteredSpectrumAccess getScanFilter() {
        ScanFilteredSpectrumAccess fsa = new ScanFilteredSpectrumAccess(rdWhiteList.isSelected());
        int count = 0;

        int runCol = cbRun.getSelectedIndex()-1;
        int scanCol = cbScan.getSelectedIndex()-1;
        csvScans.csvChanged();
        CSVRandomAccess csv = csvScans.getCSV();
        //go through the csv
        for (int i = 0; i < csv.getRowCount(); i++) {
            String run = csv.getValue(runCol, i).toLowerCase();
            String scan = csv.getValue(scanCol, i);
            Integer sn = Integer.MIN_VALUE;
            try {
                if (scan.trim().contentEquals("*")) {
                    sn = null;
                } else {
                    sn = Integer.parseInt(scan);
                }
                fsa.SelectScan(run, sn);
                count ++;
            } catch (NumberFormatException nfe) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING,scan + " is not recognised as number (scan-number)");
                continue;
            }
        }
        
        
//        DefaultTableModel tm = (DefaultTableModel) tblScanFilter.getModel();
//        for (int i = 0; i< tm.getRowCount() - 1; i++) {
//            if (tm.getValueAt(i, 0) != null&& tm.getValueAt(i, 1) != null) {
//                fsa.SelectScan(tm.getValueAt(i, 0).toString(), new Integer(tm.getValueAt(i, 1).toString()));
//                count ++;
//            }
//        }
        if (count>0) {
            return fsa;
        } else {
            return null;
        }
    }    
    
    public void setHeaderComboBoxes() {
        CSVRandomAccess csv = csvScans.getCSV();
        ColumnAlternatives.setupAlternatives(csv);
        int cols = csv.getMaxColumns();
        String[] comboBoxHeaders = new String[cols+1];
        comboBoxHeaders[0] = "--Select--";
        for (int i = 1;i<comboBoxHeaders.length;i++) {
            comboBoxHeaders[i] = csv.getHeader(i - 1);
        }
        
        cbRun.setModel(new DefaultComboBoxModel(comboBoxHeaders));
        cbScan.setModel(new DefaultComboBoxModel(comboBoxHeaders));
        Integer runCol = csv.getColumn("run");
        if ( runCol != null) {
            cbRun.setSelectedIndex(runCol+1);
        }

        Integer scanCol = csv.getColumn("scan");
        if ( scanCol != null) {
            cbScan.setSelectedIndex(scanCol+1);
        }        
    }
        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnSpectraFilterClear;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JComboBox cbRun;
    private javax.swing.JComboBox cbScan;
    private rappsilber.gui.components.CSVPanel csvScans;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JRadioButton rdBlackList;
    private javax.swing.JRadioButton rdWhiteList;
    // End of variables declaration//GEN-END:variables
}
