/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui.components;

import rappsilber.ms.ToleranceUnit;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class ToleranceUnitGUI extends javax.swing.JPanel {

    /** Creates new form ToleranceUnitGUI */
    public ToleranceUnitGUI() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblTolerance = new javax.swing.JLabel();
        spToleranceValue = new javax.swing.JSpinner();
        cbToleranceUnit = new javax.swing.JComboBox();

        lblTolerance.setText("Tolerance");
        lblTolerance.setToolTipText("Tollerance before Calibration");
        lblTolerance.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblToleranceMouseClicked(evt);
            }
        });

        spToleranceValue.setModel(new javax.swing.SpinnerNumberModel(Double.valueOf(0.0d), null, null, Double.valueOf(1.0d)));
        spToleranceValue.setToolTipText("Tollerance before Calibration");

        cbToleranceUnit.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ppm", "da" }));
        cbToleranceUnit.setToolTipText("Unit of tolerance \ne.g. da for absolute tolerance or ppm for relative tolerance");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(lblTolerance)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(spToleranceValue, javax.swing.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbToleranceUnit, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(lblTolerance, javax.swing.GroupLayout.DEFAULT_SIZE, 24, Short.MAX_VALUE)
            .addComponent(cbToleranceUnit)
            .addComponent(spToleranceValue, javax.swing.GroupLayout.DEFAULT_SIZE, 24, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void lblToleranceMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblToleranceMouseClicked
        spToleranceValue.requestFocusInWindow();
}//GEN-LAST:event_lblToleranceMouseClicked

    public ToleranceUnit getTolerance() {
        return new ToleranceUnit((Double)spToleranceValue.getValue(), cbToleranceUnit.getSelectedItem().toString());
    }

    public void setValue(double value) {
        spToleranceValue.getModel().setValue(Double.valueOf(value));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        spToleranceValue.setEnabled(enabled);
        lblTolerance.setEnabled(enabled);
        cbToleranceUnit.setEnabled(enabled);
    }



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cbToleranceUnit;
    private javax.swing.JLabel lblTolerance;
    private javax.swing.JSpinner spToleranceValue;
    // End of variables declaration//GEN-END:variables

}
