/*
 * Copyright 2018 Lutz Fischer <lfischer@staffmail.ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui.components.filter;

import rappsilber.config.AbstractRunConfig;
import rappsilber.ms.dataAccess.AbstractStackedSpectraAccess;
import rappsilber.ms.dataAccess.filter.spectrafilter.Denoise;

/**
 *
 * @author Lutz Fischer <lfischer@staffmail.ed.ac.uk>
 */
public class DenoiseFilterGui extends javax.swing.JPanel {

    
    /**
     * Creates new form DenoiseFilterGui
     */
    public DenoiseFilterGui() {
        initComponents();
        Denoise d = new Denoise(new AbstractRunConfig() {});
        spMinMZ.setValue(d.getMinMZ());
        spMaxMZ.setValue(d.getMaxMZ());
        spPeaks.setValue(d.getPeaks());
        spWindow.setValue(d.getWindow());
    }

    
    /**
     * @return the minMZ
     */
    public boolean getEnabled() {
        return ckDenoise.isSelected();
    }
    

    /**
     * @return the minMZ
     */
    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ckDenoise.setSelected(enabled);
        ckDenoiseActionPerformed(null);
    }

    @Override
    public boolean isEnabled() {
        return ckDenoise.isSelected();
    }

    
    
    /**
     * @return the minMZ
     */
    public double getMinMZ() {
        return (Double)spMinMZ.getValue();
    }

    /**
     * @param minMZ the minMZ to set
     */
    public void setMinMZ(double minMZ) {
        spMinMZ.setValue(minMZ);
    }

    /**
     * @return the maxMZ
     */
    public double getMaxMZ() {
        return (Double)spMaxMZ.getValue();
    }

    /**
     * @param maxMZ the maxMZ to set
     */
    public void setMaxMZ(double maxMZ) {
        spMaxMZ.setValue(maxMZ);
    }

    /**
     * @return the window
     */
    public double getWindow() {
        return (Double)spWindow.getValue();
    }

    /**
     * @param window the window to set
     */
    public void setWindow(double window) {
        spWindow.setValue(window);
    }

    /**
     * @return the peaks
     */
    public int getPeaks() {
        return (Integer)spPeaks.getValue();
    }

    /**
     * @param peaks the peaks to set
     */
    public void setPeaks(int peaks) {
        spPeaks.setValue(peaks);
    }
    
    
    public AbstractStackedSpectraAccess getFilter() {
        if (ckDenoise.isSelected()) {
            return new Denoise(new AbstractRunConfig() {}, getMinMZ(), getMaxMZ(), getWindow(), getPeaks());
        }else 
            return null;
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        spPeaks = new javax.swing.JSpinner();
        lblPeaks = new javax.swing.JLabel();
        lblWindow = new javax.swing.JLabel();
        spWindow = new javax.swing.JSpinner();
        spMinMZ = new javax.swing.JSpinner();
        lblMinMZ = new javax.swing.JLabel();
        lblMaxMZ = new javax.swing.JLabel();
        spMaxMZ = new javax.swing.JSpinner();
        ckDenoise = new javax.swing.JCheckBox();

        spPeaks.setModel(new javax.swing.SpinnerNumberModel());

        lblPeaks.setText("peaks:");

        lblWindow.setText("in window:");

        spWindow.setModel(new javax.swing.SpinnerNumberModel(1.0d, 1.0d, 500.0d, 1.0d));

        spMinMZ.setModel(new javax.swing.SpinnerNumberModel(0.0d, 0.0d, null, 1.0d));

        lblMinMZ.setText("min m/z");

        lblMaxMZ.setText("max m/z");

        spMaxMZ.setModel(new javax.swing.SpinnerNumberModel(0.0d, 0.0d, null, 1.0d));

        ckDenoise.setSelected(true);
        ckDenoise.setText("denoise");
        ckDenoise.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ckDenoiseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblPeaks)
                            .addComponent(lblMinMZ))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(spMinMZ, javax.swing.GroupLayout.DEFAULT_SIZE, 76, Short.MAX_VALUE)
                            .addComponent(spPeaks))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED, 19, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblWindow)
                            .addComponent(lblMaxMZ))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(spWindow)
                            .addComponent(spMaxMZ, javax.swing.GroupLayout.DEFAULT_SIZE, 76, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(ckDenoise)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(ckDenoise)
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spPeaks, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblPeaks)
                    .addComponent(lblWindow)
                    .addComponent(spWindow, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(34, 34, 34)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spMinMZ, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblMinMZ)
                    .addComponent(lblMaxMZ)
                    .addComponent(spMaxMZ, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(56, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void ckDenoiseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ckDenoiseActionPerformed
        
        boolean denoise =ckDenoise.isSelected();
        lblPeaks.setEnabled(denoise);
        lblWindow.setEnabled(denoise);
        spMaxMZ.setEnabled(denoise);
        spMinMZ.setEnabled(denoise);
        lblMinMZ.setEnabled(denoise);
        lblMaxMZ.setEnabled(denoise);
        spPeaks.setEnabled(denoise);
        spWindow.setEnabled(denoise);
        super.setEnabled(denoise);
        
    }//GEN-LAST:event_ckDenoiseActionPerformed

    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox ckDenoise;
    private javax.swing.JLabel lblMaxMZ;
    private javax.swing.JLabel lblMinMZ;
    private javax.swing.JLabel lblPeaks;
    private javax.swing.JLabel lblWindow;
    private javax.swing.JSpinner spMaxMZ;
    private javax.swing.JSpinner spMinMZ;
    private javax.swing.JSpinner spPeaks;
    private javax.swing.JSpinner spWindow;
    // End of variables declaration//GEN-END:variables
}
