/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.rappsilber.utils.ProcessLauncher;
import org.rappsilber.utils.ProcessLogToTextArea;
import org.rappsilber.utils.ProcessLogger;
import org.rappsilber.utils.RArrayUtils;
import rappsilber.gui.components.GenericTextPopUpMenu;
import rappsilber.gui.logging.JTextAreaHandle;
import rappsilber.utils.Util;
import rappsilber.utils.XiVersion;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class XiDBStarterExt extends javax.swing.JFrame {
    private class StreamToLog implements Runnable{
        BufferedReader in;

        public StreamToLog(BufferedReader in) {
            this.in = in;
        }
        
        @Override
        public void run() {
            String line;
            try {
                while ((line = in.readLine()) != null) {
                    final String fl = line;
                    SwingUtilities.invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            XiDBStarterExt.this.loggingHandle.publish(fl + "\n");
                        }
                    });
                }
            } catch (IOException ex) {
                Logger.getLogger(SimpleXiGui.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private final JTextAreaHandle loggingHandle;
    

    
    
    /** Creates new form XiDBStarter */
    public XiDBStarterExt() {
        initComponents();
        this.setTitle("xi db starter - " + XiVersion.getVersionString());
//        loadList();
        dbSearch.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        GenericTextPopUpMenu copypaste = new GenericTextPopUpMenu();
        copypaste.installContextMenu(this);
        int cpus = Runtime.getRuntime().availableProcessors();
        ((javax.swing.SpinnerNumberModel)this.spThreads.getModel()).setMaximum(cpus);
        cpus = Math.max(cpus - 2, 1);
        this.spThreads.getModel().setValue(cpus);
        
        loggingHandle = new JTextAreaHandle(txtLog);
        loggingHandle.setLevel(Level.INFO);
        loggingHandle.setFilter(new Filter() {

            public boolean isLoggable(LogRecord record) {
                return true;
            }
        });
        Logger.getLogger("").addHandler(loggingHandle);
        Logger.getLogger("").setLevel(Level.INFO);
        
         try {
            BufferedReader br = Util.readFromClassPath(".rappsilber.data.ExampleConfig.conf");
            StringBuffer sb = new StringBuffer();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            txtConfig.setText(sb.toString());
            txtConfig.setCaretPosition(0);

        } catch (IOException ex) {
            Logger.getLogger(SimpleXiGui.class.getName()).log(Level.SEVERE, null, ex);
        }
       
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bgDBSource = new javax.swing.ButtonGroup();
        bgJar = new javax.swing.ButtonGroup();
        btnRun = new javax.swing.JButton();
        cbResultsToDB = new javax.swing.JCheckBox();
        fbCSVOut = new rappsilber.gui.components.FileBrowser();
        jLabel1 = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        dbSearch = new rappsilber.gui.components.db.GetSearch();
        fbJAR = new rappsilber.gui.components.FileBrowser();
        jLabel4 = new javax.swing.JLabel();
        spThreads = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        spRAM = new javax.swing.JSpinner();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        rbJarAuto = new javax.swing.JRadioButton();
        rbJarSelect = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        txtConfig = new javax.swing.JTextArea();
        fbCSVPeakList = new rappsilber.gui.components.FileBrowser();
        jLabel2 = new javax.swing.JLabel();
        localPicker1 = new rappsilber.gui.components.LocalPicker();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtLog = new javax.swing.JTextArea();
        ckTopOnly = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnRun.setText("Run");
        bgJar.add(btnRun);
        btnRun.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRunActionPerformed(evt);
            }
        });

        cbResultsToDB.setText("Write to Database");

        fbCSVOut.setDescription("CSV-Files");
        fbCSVOut.setExtensions(new String[] {"csv", "csv.gz"});

        jLabel1.setText("csv-output:");

        fbJAR.setToolTipText("");
        fbJAR.setEnabled(false);
        fbJAR.setExtensions(new String[] {"jar"});

        jLabel4.setText("xiVersion");

        spThreads.setModel(new javax.swing.SpinnerNumberModel(1, 1, null, 1));

        jLabel5.setText("Threads");

        spRAM.setModel(new javax.swing.SpinnerNumberModel(20, 4, null, 1));

        jLabel6.setText("RAM");

        jLabel7.setText("GB");

        bgJar.add(rbJarAuto);
        rbJarAuto.setSelected(true);
        rbJarAuto.setText("automatic");
        rbJarAuto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbJarAutoActionPerformed(evt);
            }
        });

        bgJar.add(rbJarSelect);
        rbJarSelect.setText("Select");
        rbJarSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbJarSelectActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(dbSearch, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(spThreads, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(spRAM, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rbJarAuto)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rbJarSelect)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fbJAR, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel7)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(dbSearch, javax.swing.GroupLayout.DEFAULT_SIZE, 298, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spThreads, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5)
                    .addComponent(spRAM, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel4)
                    .addComponent(fbJAR, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(rbJarAuto)
                    .addComponent(rbJarSelect))
                .addContainerGap())
        );

        jTabbedPane1.addTab("Select Search", jPanel1);

        txtConfig.setColumns(20);
        txtConfig.setRows(5);
        jScrollPane4.setViewportView(txtConfig);

        fbCSVPeakList.setDescription("CSV-Files");
        fbCSVPeakList.setExtensions(new String[] {"csv"});

        jLabel2.setText("Matched peak-list:");

        localPicker1.setDefaultLocal(java.util.Locale.ENGLISH);

        jLabel3.setText("CSV Number Format");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane4)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(localPicker1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(fbCSVPeakList, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 288, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(localPicker1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(fbCSVPeakList, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addContainerGap())
        );

        jTabbedPane1.addTab("Custom Config", jPanel3);

        txtLog.setColumns(20);
        txtLog.setRows(5);
        jScrollPane1.setViewportView(txtLog);

        jTabbedPane1.addTab("Log", jScrollPane1);

        ckTopOnly.setText("Topmatches Only");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(cbResultsToDB)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(fbCSVOut, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(ckTopOnly)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(btnRun))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jTabbedPane1)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(btnRun)
                        .addComponent(ckTopOnly))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(cbResultsToDB)
                        .addComponent(jLabel1))
                    .addComponent(fbCSVOut, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    
    protected void innerStartXiSEARCH(File jar, int threads, int GB, List<String> extraArgs, boolean writeDB, boolean topOnly, File csvOut, String logDir, int searchID, String name) throws IOException {
        // setup the process
        SimpleDateFormat logDate = new SimpleDateFormat("yyyyMMdd_HHmmss");

        ArrayList<String> args = new ArrayList<>();
        // first argument is the same java executable used here
        args.add(Util.findJava());
        // -jar xiFDR.jar
        args.add("-Dfile.encoding=UTF-8");
        /*if (autoAddOpens && Util.getJavaMajorVersion() >= 11) {
            
            args.add("--add-opens");
            args.add("java.base/java.lang=ALL-UNNAMED");
        }*/
        args.add("-Xmx" + GB + "g");
        args.add("-DXI_DB_CONNECTION="+dbSearch.getConnectionString());
        args.add("-DXI_DB_USER="+ dbSearch.getUser()); 
        args.add("-DXI_DB_PASSWD="+ dbSearch.getPassword()); 
        args.add("-DXI_SHOW_DEBUG=1");
        args.add("-DXI_DB_OUTPUT=" + (writeDB?"YES":"NO"));
        ArrayList<String> extraConfig = new ArrayList<>();
        extraConfig.add("UseCPUs:" + threads);
        extraConfig.add("TOPMATCHESONLY:"+topOnly);
        for (String a : extraArgs) {
            extraConfig.add(a);
        }
        
        if (extraConfig.size()>0) {
            args.add("-DXI_EXTRA_CONFIG=" + RArrayUtils.toString(extraConfig, "\n"));
        }
        if (csvOut != null) {
            args.add("-DXI_CSV_OUTPUT="+ csvOut.getAbsolutePath());
        } 


        if (fbCSVOut.getFile() != null) {
            args.add("-DXI_CSV_LOCALE=" + localPicker1.getSelectLocale().getDisplayName());
        }
        
        if (fbCSVPeakList.getFile() != null) {
            args.add("-DXI_CSV_PEAKS=" + fbCSVPeakList.getFile().getAbsolutePath());
        }
        
        args.add("-cp");
        args.add(jar.getAbsolutePath());
        args.add("rappsilber.applications.XiDB");
        args.add(""+searchID);
        args.add(name);
        
        final ProcessLauncher launcher = new ProcessLauncher(args);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO,"running: " + launcher.getCommandLine());
        Calendar c = Calendar.getInstance();

        String sdate = logDate.format(c.getTime());
        ProcessLogger plout = null;
        if (logDir == null || logDir.isEmpty()) {
            logDir = jar.getParent()+File.separator + "log"+File.separator;
        }
        try {
            plout = new ProcessLogger(logDir + sdate+"_"+dbSearch.getConnectionString().replaceAll("[^a-zA-Z0-9\\._]","_")+"_Search_" + dbSearch.getSelectedSearchIds()[0] + ".log", true);
            plout.standardOutput("\n"+sdate+": Start Xi on database " + dbSearch.getConnectionString() + " starting serach " + dbSearch.getSelectedSearchIds()[0] + "\n");
            launcher.addOutputListener(plout);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        launcher.addOutputListener(new ProcessLogToTextArea(txtLog));
        
        Runnable runnable = new Runnable() {
            public void run() {
                launcher.launch();
            }
        };
        new Thread(runnable,"xiSEARCH Process").start();
        
    }

    private void btnRunActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRunActionPerformed
        File version = null;
        if (rbJarSelect.isSelected()) {
            version = fbJAR.getFile();
        } else {
            try {
                Statement st = dbSearch.getConnection().createStatement();
                ResultSet rs = st.executeQuery("SELECT v.version FROM search s INNER JOIN xiversions v ON s.xiversion = v.id WHERE s.id = " + dbSearch.getSelectedSearchIds()[0]);
                rs.next();
                String sversion = rs.getString(1);
                version = Util.getFileRelative(Pattern.compile(".*"+sversion + ".*\\.jar"));
                if (version == null) {
                    JOptionPane.showMessageDialog(this, "Could not find xisearch version "+ sversion , "Could not find version", JOptionPane.ERROR_MESSAGE);
                    rbJarSelect.setSelected(true);
                    fbJAR.setEnabled(true);
                    fbJAR.requestFocus();
                    return;
                }
            } catch (SQLException ex) {
                Logger.getLogger(XiDBStarterExt.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        ArrayList<String> extraConfig = new ArrayList<>();
        String[] extraConfs = txtConfig.getText().split("[\\n\\r]+");
        for (String s :  extraConfs) {
            s=s.trim();
            if (!s.startsWith("#") && s.length()>0) {
                extraConfig.add(s);
            }
        }

        try {
            innerStartXiSEARCH(version, (Integer)spThreads.getModel().getValue(), (Integer)spRAM.getModel().getValue(), extraConfig, cbResultsToDB.isSelected(), ckTopOnly.isSelected(), fbCSVOut.getFile(), "", dbSearch.getSelectedSearchIds()[0],"");
            
        } catch (IOException ex) {
            Logger.getLogger(XiDBStarterExt.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }//GEN-LAST:event_btnRunActionPerformed

    private void rbJarSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbJarSelectActionPerformed
        fbJAR.setEnabled(rbJarSelect.isSelected());
    }//GEN-LAST:event_rbJarSelectActionPerformed

    private void rbJarAutoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbJarAutoActionPerformed
        fbJAR.setEnabled(!rbJarAuto.isSelected());
    }//GEN-LAST:event_rbJarAutoActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(XiDBStarterExt.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(XiDBStarterExt.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(XiDBStarterExt.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(XiDBStarterExt.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new XiDBStarterExt().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgDBSource;
    private javax.swing.ButtonGroup bgJar;
    private javax.swing.JButton btnRun;
    private javax.swing.JCheckBox cbResultsToDB;
    private javax.swing.JCheckBox ckTopOnly;
    private rappsilber.gui.components.db.GetSearch dbSearch;
    private rappsilber.gui.components.FileBrowser fbCSVOut;
    private rappsilber.gui.components.FileBrowser fbCSVPeakList;
    private rappsilber.gui.components.FileBrowser fbJAR;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JTabbedPane jTabbedPane1;
    private rappsilber.gui.components.LocalPicker localPicker1;
    private javax.swing.JRadioButton rbJarAuto;
    private javax.swing.JRadioButton rbJarSelect;
    private javax.swing.JSpinner spRAM;
    private javax.swing.JSpinner spThreads;
    private javax.swing.JTextArea txtConfig;
    private javax.swing.JTextArea txtLog;
    // End of variables declaration//GEN-END:variables
}
