/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rappsilber.gui.components;

import java.util.TimerTask;
import javax.swing.SwingUtilities;
import rappsilber.applications.XiProcess;

/**
 *
 * @author Lutz Fischer <lfischer@staffmail.ed.ac.uk>
 */
public class ThreadAdjust extends javax.swing.JPanel {

    XiProcess xiProcess;
    /**
     * Creates new form ThreadAdjust
     */
    public ThreadAdjust() {
        initComponents();
        java.util.Timer scanTimer = new java.util.Timer("Timer - search thread count",true);
        scanTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                updateThreadCount();
            }
        }, 0, 2000);
    }

    public void setXiProcess(XiProcess p) {
        this.xiProcess = p;
    }
    
    public void updateThreadCount() {
        if (xiProcess != null) {
            final int a = xiProcess.countActiveSearchThread();
            final int s = xiProcess.countSelectedSearchThread();
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    txtThreads.setText(a + "/" + s);
                }
            });
            if (!lblThreads.isVisible()) {
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                        
                        setComponentsVisible(true);
                    }
                });
            }
            if (!xiProcess.isRunning() && s > 0) {
                    SwingUtilities.invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            setComponentsVisible(false); 
                        }
                    });
            }
        } else {
            if (lblThreads.isVisible()  && !java.beans.Beans.isDesignTime()) {
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                        setComponentsVisible(false); 
                    }
                });
            }
        }
    }

    protected void setComponentsVisible(boolean vis) {
        if (!java.beans.Beans.isDesignTime()) {
            lblThreads.setVisible(vis);
            txtThreads.setVisible(vis);
            btnIncThread.setVisible(vis);
            btnDecThread.setVisible(vis);
            this.setVisible(vis);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblThreads = new javax.swing.JLabel();
        txtThreads = new javax.swing.JTextField();
        btnIncThread = new javax.swing.JButton();
        btnDecThread = new javax.swing.JButton();

        lblThreads.setText("Threads");

        txtThreads.setMaximumSize(new java.awt.Dimension(100, 100));
        txtThreads.setMinimumSize(new java.awt.Dimension(50, 19));

        btnIncThread.setText("+");
        btnIncThread.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnIncThreadActionPerformed(evt);
            }
        });

        btnDecThread.setText("-");
        btnDecThread.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDecThreadActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(lblThreads)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(txtThreads, javax.swing.GroupLayout.DEFAULT_SIZE, 50, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnIncThread)
                .addGap(0, 0, 0)
                .addComponent(btnDecThread))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(txtThreads, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnIncThread)
                    .addComponent(btnDecThread)
                    .addComponent(lblThreads))
                .addGap(0, 0, 0))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnIncThreadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnIncThreadActionPerformed
        if (xiProcess != null) {
            xiProcess.increaseSearchThread();
        }
        updateThreadCount();
    }//GEN-LAST:event_btnIncThreadActionPerformed

    private void btnDecThreadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDecThreadActionPerformed
        if (xiProcess != null) {
            xiProcess.decreaseSearchThread();
        }
        updateThreadCount();
    }//GEN-LAST:event_btnDecThreadActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnDecThread;
    private javax.swing.JButton btnIncThread;
    private javax.swing.JLabel lblThreads;
    private javax.swing.JTextField txtThreads;
    // End of variables declaration//GEN-END:variables
}
