/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui.components;

import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import rappsilber.ms.dataAccess.calibration.CalibrateConstantRelativeShift;
import rappsilber.ms.dataAccess.calibration.CalibrateConstantShift;
import rappsilber.ms.dataAccess.calibration.StreamingCalibrate;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class LinearCalibration extends javax.swing.JPanel {

    /** Creates new form LinearCalibration */
    public LinearCalibration() {
        initComponents();

        DefaultTableModel tm = ((DefaultTableModel)tblTargetPeaks.getModel());
        tm.addTableModelListener(new AutoAddTableModelListener());

        tolerance.setValue(20);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane3 = new javax.swing.JScrollPane();
        tblTargetPeaks = new javax.swing.JTable();
        fbMZListFile = new rappsilber.gui.components.FileBrowser();
        btnReadMassFilter = new javax.swing.JButton();
        tolerance = new rappsilber.gui.components.ToleranceUnitGUI();
        ckRelative = new javax.swing.JCheckBox();
        ckEnable = new javax.swing.JCheckBox();

        tblTargetPeaks.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null}
            },
            new String [] {
                "target m/z"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Double.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        tblTargetPeaks.setEnabled(false);
        tblTargetPeaks.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                tblTargetPeakstblFilterKeyReleased(evt);
            }
        });
        jScrollPane3.setViewportView(tblTargetPeaks);

        fbMZListFile.setEnabled(false);

        btnReadMassFilter.setText("Read");
        btnReadMassFilter.setEnabled(false);
        btnReadMassFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnReadMassFilterActionPerformed(evt);
            }
        });

        tolerance.setEnabled(false);

        ckRelative.setText("Relative Shift");
        ckRelative.setEnabled(false);

        ckEnable.setText("Calibrate");
        ckEnable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ckEnableActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .addComponent(ckEnable, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(tolerance, javax.swing.GroupLayout.PREFERRED_SIZE, 182, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(6, 6, 6)
                        .addComponent(ckRelative)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(fbMZListFile, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(btnReadMassFilter)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(ckEnable)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 152, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tolerance, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(fbMZListFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(btnReadMassFilter))
                    .addComponent(ckRelative))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void tblTargetPeakstblFilterKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tblTargetPeakstblFilterKeyReleased
        if(evt.getKeyCode() == KeyEvent.VK_DELETE) {
            JTable tbl = (JTable) evt.getSource();
            if (tbl.getSelectedRowCount() > 0) {
                DefaultTableModel tm = (DefaultTableModel) tbl.getModel();
                int LastRow = tm.getRowCount();
                int[] rows = tbl.getSelectedRows();
                for (int r = rows.length;r-->0;) {
                    if (r<LastRow) {
                        tm.removeRow(r);
                    }
                }
            }
        }
}//GEN-LAST:event_tblTargetPeakstblFilterKeyReleased

    private void btnReadMassFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnReadMassFilterActionPerformed
        DefaultTableModel tm = ((DefaultTableModel)tblTargetPeaks.getModel());

        String file  = fbMZListFile.getText();
        if (file != null || file.length() >0) {
            File in = new File(file);
            if (!in.exists()) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            BufferedReader br;
            try {
                br = new BufferedReader(new FileReader(in));
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "file " + file + " not found", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String line;
            try {
                int editRow = tm.getRowCount() - 1;
                while ((line = br.readLine()) != null) {
                    if (line.matches("^\\s*[0-9]*(\\.[0-9]*)?\\s*(,.*)?$")) {
                        String[] data = line.split(",",2);
                        tm.setValueAt(Double.valueOf(data[0]), editRow++, 0);
                    }
                }
            } catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error while reading file " + file + " !", "File Not Found", JOptionPane.ERROR_MESSAGE);
                return;
            }
        }
}//GEN-LAST:event_btnReadMassFilterActionPerformed

    private void ckEnableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ckEnableActionPerformed
        boolean enable = ckEnable.isSelected();
        tblTargetPeaks.setEnabled(enable);
        tolerance.setEnabled(enable);
        fbMZListFile.setEnabled(enable);
        btnReadMassFilter.setEnabled(enable);
        ckRelative.setEnabled(enable);

    }//GEN-LAST:event_ckEnableActionPerformed



    public StreamingCalibrate getCalibration() {
        if (! ckEnable.isSelected()) {
            return null;
        }
        int peakCount = tblTargetPeaks.getRowCount() - 1;
        if (peakCount < 1) {
            return null;
        }

        double[] peaks = new double[peakCount];
        for (int p = 0 ; p< peakCount; p++) {
            peaks[p] = ((Double) tblTargetPeaks.getValueAt(p, 0)).doubleValue();
        }
        if (ckRelative.isSelected()) {
            return new CalibrateConstantRelativeShift(peaks, tolerance.getTolerance());
        } else {
            return new CalibrateConstantShift(peaks, tolerance.getTolerance());
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnReadMassFilter;
    private javax.swing.JCheckBox ckEnable;
    private javax.swing.JCheckBox ckRelative;
    private rappsilber.gui.components.FileBrowser fbMZListFile;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable tblTargetPeaks;
    private rappsilber.gui.components.ToleranceUnitGUI tolerance;
    // End of variables declaration//GEN-END:variables

}
