/* 
 * Copyright 2016 Lutz Fischer <l.fischer@ed.ac.uk>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package rappsilber.gui;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
//import rappsilber.applications.XiDB;
//import rappsilber.applications.XiDBManualStart;

/**
 *
 * @author Lutz Fischer <l.fischer@ed.ac.uk>
 */
public class XiDBGetPeptides extends javax.swing.JFrame {


    public class RunComboBoxModel extends  AbstractListModel implements ComboBoxModel{
        
        private class line {

            public line(String name, String notes, int id, String status) {
                this.name = name;
                this.notes = notes;
                this.id = id;
                this.status = status;
            }
            
            String name;
            String notes;
            String status;
            int id;
            
            public String toString() {
                return "" + id + "-" + status + " - " + name + " - " + notes;
            }
            
        }
        ArrayList<String> name = new ArrayList<String>();
        ArrayList<Integer> ids =new ArrayList<Integer>();
        ArrayList<String> notes =new ArrayList<String>();
        ArrayList<line> lines = new ArrayList<line>();
        int selected = -1;

        public RunComboBoxModel(ResultSet rs) {
            try {
                while (rs.next()) {
                    name.add(rs.getString("name"));
                    ids.add(rs.getInt("id"));
                    lines.add(new line(rs.getString("name"), rs.getString("notes"), rs.getInt("id"), rs.getString("status")));
                }
            } catch (SQLException ex) {
                Logger.getLogger(XiDBGetPeptides.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        
        
        public int getSize() {
            return lines.size();
        }

        public Object getElementAt(int index) {
            return lines.get(index);
        }
        
        public int getId(int index) {
            return ids.get(index);
        }

        public void setSelectedItem(Object anItem) {
            selected = lines.indexOf(anItem);
            
        }

        public line getSelectedItem() {
            if (selected <0) {
                return null;
            }
            return lines.get(selected);
        }

        public String getSelectedName() {
            return lines.get(selected).name;
        }
        
        public int getSelectedID() {
            return lines.get(selected).id;
        }
        
    }
    
    
    
    /** Creates new form XiDBStarter */
    public XiDBGetPeptides() {
        initComponents();
//        loadList();
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnRun = new javax.swing.JButton();
        lblStatus = new javax.swing.JLabel();
        fbLinear = new rappsilber.gui.components.FileBrowser();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        fbXL = new rappsilber.gui.components.FileBrowser();
        getSearch1 = new rappsilber.gui.components.db.GetSearch();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnRun.setText("Run");
        btnRun.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRunActionPerformed(evt);
            }
        });

        lblStatus.setText("status");

        fbLinear.setDescription("CSV-Files");
        fbLinear.setExtensions(new String[] {"csv"});
        fbLinear.setLocalPropertyKey("UniqueDBPeptidesCSVOut");

        jLabel1.setText("Linear Peptides");

        jLabel2.setText("Cross-linkable Peptides");

        fbXL.setDescription("CSV-file");
        fbXL.setExtensions(new String[] {"csv"});
        fbXL.setLocalPropertyKey("UniqueDBPeptidesCSVOut");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(btnRun))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(fbXL, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(lblStatus)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addGap(41, 41, 41)
                                .addComponent(fbLinear, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))))
                .addContainerGap())
            .addComponent(getSearch1, javax.swing.GroupLayout.DEFAULT_SIZE, 854, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lblStatus)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(getSearch1, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(96, 96, 96)
                        .addComponent(btnRun))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(fbLinear, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(fbXL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2)))))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnRunActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRunActionPerformed
        final File xlout = fbXL.getFile();
        final File lout = fbLinear.getFile();
        Runnable runnable = new Runnable() {
            public void run() {
                btnRun.setEnabled(false);
                int id = getSearch1.getSelectedSearchIds()[0];
                String name = getSearch1.getSelectedNames()[0];
                try {
                    rappsilber.db.peptides.WriteUniquePeptides.main(new String[]{Integer.toString(id), name, xlout.getAbsolutePath(),lout.getAbsolutePath()});
                    
                } catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.OFF, "Error during search", e);
                    e.printStackTrace();
                }
                btnRun.setEnabled(true);
            }
            
        };
        
        new Thread(runnable).start();
        
        
    }//GEN-LAST:event_btnRunActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(XiDBGetPeptides.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(XiDBGetPeptides.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(XiDBGetPeptides.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(XiDBGetPeptides.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new XiDBGetPeptides().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnRun;
    private rappsilber.gui.components.FileBrowser fbLinear;
    private rappsilber.gui.components.FileBrowser fbXL;
    private rappsilber.gui.components.db.GetSearch getSearch1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel lblStatus;
    // End of variables declaration//GEN-END:variables
}
